#version 330

in vec2 uv;
in float brightness_frag;
in float texture_index_frag;

out vec4 fragment_color;

uniform sampler2D kukka1;
uniform sampler2D kukka2;
uniform sampler2D kukka3;
uniform sampler2D valo;
uniform sampler2D valo2;
uniform sampler2D valo3;
uniform sampler2D taplat;
uniform sampler2D taplat2;

uniform vec3 light1_position;
uniform vec3 light2_position;
uniform vec3 light1_intensity;
uniform vec3 light2_intensity;
uniform vec3 ambient_light;
uniform float desaturate_multiplier;
uniform float fade_to_black_multiplier;

void main()
{
	vec4 texture_sample;
	if (texture_index_frag > -0.01 && texture_index_frag < 1.01)
	{
		texture_sample = texture(kukka1, uv);
	}
	else if (texture_index_frag > 0.99 && texture_index_frag < 1.01)
	{
		texture_sample = texture(kukka2, uv);
	}
	else if (texture_index_frag > 1.99 && texture_index_frag < 2.01)
	{
		texture_sample = texture(kukka3, uv);
	}
	else if (texture_index_frag > 2.99 && texture_index_frag < 3.01)
	{
		texture_sample = texture(valo, uv);
	}
	else if (texture_index_frag > 3.99 && texture_index_frag < 4.01)
	{
		texture_sample = texture(valo2, uv);
	}
	else if (texture_index_frag > 4.99 && texture_index_frag < 5.01)
	{
		texture_sample = texture(valo3, uv);
	}
	else if (texture_index_frag > 5.99 && texture_index_frag < 6.01)
	{
		texture_sample = texture(taplat, uv);
	}
	else if (texture_index_frag > 6.99 && texture_index_frag < 7.01)
	{
		texture_sample = texture(taplat2, uv);
	}
	else
	{
		texture_sample = vec4(0.0);
	}
	texture_sample.a *= brightness_frag;
	fragment_color = vec4(vec3(fade_to_black_multiplier), 1.0) * texture_sample;
	/*
	else if (round(uv.z) == 2)
	{
    	fragment_color = vec4(0.0, 1.0, 0.0, 1.0); //texture(textures[texture_index_frag], uv);
	}
	else if (round(uv.z) == 3)
	{
    	fragment_color = vec4(0.0, 0.0, 1.0, 1.0); //texture(textures[texture_index_frag], uv);
	}
	else if (round(uv.z) == 4)
	{
    	fragment_color = vec4(1.0, 1.0, 0.0, 1.0); //texture(textures[texture_index_frag], uv);
	}*/
}